// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : entityPlayer.cpp
// Date           : February 2008
//
// Description    : This file defines the EntityPlayer class for the user's
//                  controllable avatar.  Once instantiated, the primary
//                  methods for control are Jump(), Run() and Drop().  The
//                  game loop (via CGame) must check IsDead() to determine
//                  if the player has died.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "entity.h"
#include "text.h"






class EntityPlayer : public Entity 
{

  protected:

    Entity*                 m_pCannon;
    Entity*                 m_pSub;

    int                     m_soundRunDelay;
    int                     m_soundRun;
    bool                    m_isDropping;
    int                     m_Character;
    Dobbs::PlayerState      m_PlayerState;

    int                     m_speedGrass;
    int                     m_speedGlue;
    int                     m_soundGrass;
    int                     m_soundGlue;
    int                     m_gravityDelay;
    float                   m_gravityAccel;
    float                   m_gravityMax;

    bool                    m_WarpIn;
    bool                    m_WarpOut;

    float                   m_WarpTime;

    void                    loadResources();
    void                    unloadResources();


  public:

    EntityPlayer();
    ~EntityPlayer();

    void                    Drop( Level& aLevel );

    Dobbs::PlayerState      GetState();

    virtual void            Render( int XOffset, int YOffset );

    // Used to tweak the character-specific values
    void                    AdjustPhysics( int dSpeedGrass, int dSpeedGlue,
                                           int dSoundGrass, int dSoundGlue,
                                           int dGravDelay, float dGravAccel, float dGravMax,
                                           float dJumpInit, int dJumpMax );

    virtual void            UpdateTimed( Level& aLevel, float ElapsedTime );
    virtual void            Update( Level& aLevel );

    virtual void            HandleAnimation();

    void                    RunSound( bool Running = true );

    virtual void            OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity );

    void                    SetPlayerState( Dobbs::PlayerState State );

    void                    IntoCannon( Entity* pCannon );
    void                    ShootFromCannon();

    void                    IntoSub( Entity* pSub );
    void                    ExitSub();

    void                    WarpIn();
    void                    WarpOut();

};

